<?php
/**
* @wordpress-plugin
* Plugin Name:  Daily Readings 
* Plugin URI:   https://www.dailyreadings.eu
* description:  A plugin that provides the Mass Daily Readings according to different rites
* Version:      2.9.2
* Author:       Andrea Chiesa
* Author URI:   https://www.dailyreadings.eu/about-me
* Text Domain:  daily-readings
* Domain Path:  /languages
* License:      GPLv2 or later
* License URI:  https://www.gnu.org/licenses/gpl-2.0.html
*/

    include_once( 'includes/settings.php' );
    include_once( 'includes/widget.php' );


    function daily_readings_build_readings_content() {
        load_plugin_textdomain( 'daily-readings', false, 'daily-readings/languages' );
        $daily_readings_options = get_option( 'daily_readings_option_name' );
        $rite_0 = $daily_readings_options['rite_0']; 
        $color_1 = $daily_readings_options['color_1'];
        $hide_first_reading_2 = isset($daily_readings_options['hide_first_reading_2']) ? $daily_readings_options['hide_first_reading_2'] : false;
        $hide_psalm_3 = isset($daily_readings_options['hide_psalm_3']) ? $daily_readings_options['hide_psalm_3'] : false; 
        $hide_second_reading_4 = isset($daily_readings_options['hide_second_reading_4']) ? $daily_readings_options['hide_second_reading_4'] : false; 
        $hide_gospel_5 = isset($daily_readings_options['hide_gospel_5']) ? $daily_readings_options['hide_gospel_5'] : false; 
        $show_short_titles = isset($daily_readings_options['show_short_titles']) ? $daily_readings_options['show_short_titles'] : false; 
        $time_zone_7 = $daily_readings_options['time_zone_7'];
        $direction = ($rite_0 == 'AR' || $rite_0 == 'BYA' || $rite_0 == 'CHA' || $rite_0 == 'COA' || $rite_0 == 'MAA' || $rite_0 == 'SYA' || $rite_0 == 'HE') ? 'rtl' : 'ltr' ; 

        $targetDate = $time_zone_7 != 'default' ? strtotime($time_zone_7) : '';
        $currentDate = $targetDate != '' ? date('Ymd', $targetDate) : current_time( 'Ymd' );

        $responseLiturgy = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date='. $currentDate .'&lang='. $rite_0 .'&type=liturgic_t');

        $responseTitleEpistle = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_lt&content=EP');
        $responseShortTitleEpistle = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_st&content=EP');

        $responseTitleFirstReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_lt&content=FR');
        $responseTitlePsalm = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_lt&content=PS');
        $responseTitleSecondReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_lt&content=SR');
        $responseTitleGospel = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_lt&content=GSP');

        $responseShortTitleFirstReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_st&content=FR');
        $responseShortTitlePsalm = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_st&content=PS');
        $responseShortTitleSecondReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_st&content=SR');
        $responseShortTitleGospel = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading_st&content=GSP');


        $Content = '<style>';
        $Content .= '.daily-readings-wrapper h4.daily-readings-reading-heading {';
        $Content .= 'color: ' . $color_1 . ';';
        $Content .= '}';
        $Content .= '</style>';

        $Content .= '<script> 
                        let DR_CONFIGS = {
                            "rite": "' . $rite_0 . '",
                            "timeZone": "' . $time_zone_7 . '",
                            "targetDate": "' . $currentDate . '",
                            "firstLecture": "' . __( 'First Reading', 'daily-readings' ) . '",
                            "psalm": "' . __( 'Psalm', 'daily-readings' ) . '",
                            "secondLecture": "' . __( 'Second Reading', 'daily-readings' ) . '",
                            "gospel": "' . __( 'Gospel', 'daily-readings' ) . '",
                            "noReadings": "' . __( 'No readings available', 'daily-readings' ) . '",';

        if ($hide_first_reading_2) {
            $Content .= '"hideFirstLecture": true,';
        } else {
            $Content .= '"hideFirstLecture": false,';
        }

        if ($hide_psalm_3) {
            $Content .= '"hidePsalm": true,';
        } else {
            $Content .= '"hidePsalm": false,';
        }

        if ($hide_second_reading_4) {
            $Content .= '"hideSecondLecture": true,';
        } else {
            $Content .= '"hideSecondLecture": false,';
        }

        if ($hide_gospel_5) {
            $Content .= '"hideGospel": true';
        } else {
            $Content .= '"hideGospel": false';
        }

        $Content .= '}</script>';

        $Content .= '<div class="daily-readings-wrapper"><br>
                        <p class="daily-readings-datepicker">
                            <span>' . __( 'Select date', 'daily-readings' ) . '</span>
                            <input type="hidden" id="datepicker">
                        </p>';

        $Content .= '<div id="direction-wrapper" dir="' . $direction . '" >';                

        $Content .= '<h3 class="daily-readings-date">' . $responseLiturgy . '</h3>';

        $Content .= '<div id="epistleReading" class="reading-wrapper">';

        if ((!$hide_first_reading_2 || !$hide_second_reading_4) && $responseTitleEpistle ) {
            $responseEpistle = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading&content=EP');
            $Content .= daily_readings_renderReading($responseTitleEpistle, $responseEpistle, true);

        } else if(($hide_first_reading_2 && $hide_second_reading_4) && $responseShortTitleEpistle && $show_short_titles){
            $Content .= daily_readings_renderReading($responseShortTitleEpistle, '', false);
        }
        $Content .= '</div>';

        $Content .= '<div id="firstReading" class="reading-wrapper">';

        if (!$hide_first_reading_2 && $responseTitleFirstReading ) {
            $responseFirstReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading&content=FR');
            $Content .= daily_readings_renderReading($responseTitleFirstReading, $responseFirstReading, true);

        } else if($hide_first_reading_2 && $responseShortTitleFirstReading && $show_short_titles){
            $Content .= daily_readings_renderReading($responseShortTitleFirstReading, '', false);
        }

        $Content .= '</div>';

        $Content .= '<div id="psalmReading" class="reading-wrapper">';

        if (!$hide_psalm_3 && $responseTitlePsalm) {
            $responsePsalm = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading&content=PS');
            $Content .= daily_readings_renderReading($responseTitlePsalm, $responsePsalm, true);

        } else if($hide_psalm_3 && $responseShortTitlePsalm && $show_short_titles){
            $Content .= daily_readings_renderReading($responseShortTitlePsalm, '', false);
        }

        $Content .= '</div>';

        $Content .= '<div id="secondReading" class="reading-wrapper">';

        if (!$hide_second_reading_4 && $responseTitleSecondReading) {
            $responseSecondReading = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading&content=SR');
            $Content .= daily_readings_renderReading($responseTitleSecondReading, $responseSecondReading, true);
       
        } else if($hide_second_reading_4 && $responseShortTitleSecondReading && $show_short_titles){
            $Content .= daily_readings_renderReading($responseShortTitleSecondReading, '', false);
        }


        $Content .= '</div>';

        $Content .= '<div id="gospelReading" class="reading-wrapper">';

        if (!$hide_gospel_5 && $responseTitleGospel) {
            $responseGospel = fetch_reading('https://feed.evangelizo.org/v2/reader.php?date=' . $currentDate . '&lang=' . $rite_0 . '&type=reading&content=GSP');
            $Content .= daily_readings_renderReading($responseTitleGospel, $responseGospel, false);

        } else if($hide_gospel_5 && $responseShortTitleGospel && $show_short_titles){
            $Content .= daily_readings_renderReading($responseShortTitleGospel, '', false);
        }


        $Content .= '</div>';

        $Content .= '</div>'; //direction-wrapper

        $Content .= '</div>'; //main

        return $Content;
    }

    function fetch_reading($url) {
        $response = wp_remote_get($url);
        $response = wp_remote_retrieve_body($response);

        if (str_contains($response, 'Error : wrong')) {
            return null;
        }

        return $response;
    }


    function daily_readings_renderReading($lecture, $verses, $remove) {
        $Content = '<h4 class="daily-readings-reading-heading">' . $lecture . '</h4>';
        $Content .= '<div class="daily-readings-reading">' . remove_copyright($verses, $remove) . '</div>';

        return $Content;
    }

    function remove_copyright($verses, $remove) {
        if(!$remove){
            return $verses;
        }

        for ($i = 0; $i < 2; $i++) {
            $verses = substr($verses, 0, strrpos($verses, '<br />'));
        }

        return $verses;
    }

    add_shortcode('sc_daily_readings', 'daily_readings_build_readings_content');

?>