/** widget and posts **/
window.onload = function() {
    if (window.jQuery) {
        jQuery(document).ready(function($) {

            // datepicker - page
            $('#datepicker').datepicker({
                dateFormat: 'yy-mm-dd',
                showOn: "button",
                buttonImage: "https://bible-assets.s3.us-east-2.amazonaws.com/assets/calendar_icon.svg",
                buttonImageOnly: true,
                buttonText: "Select date"
            });

            $('#datepicker').on('change', function(e) {

                var newDate = $(this).val();

                swipe();

                var targetDate = new Date(newDate);
                var currentDate = new Date();
                const diffTime = Math.abs(targetDate - currentDate);
                const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)); 
                
                if (diffDays > 30){
                    $('.daily-readings-wrapper').append('<div id="no-readings-message">' + DR_CONFIGS.noReadings + '</div>');

                } else {
                    retrieveReadings(newDate.replace('-', ''), DR_CONFIGS.rite);
                }

            });

            function buildReading(wrapper, heading, reading, remove) {
                
                if (reading.includes('Error : wrong')) {
                    return;
                }

                var content = '<h4 class="daily-readings-reading-heading">' + heading + '</h4>' +
                    '<div class="daily-readings-reading">' + removeCopyRight(reading, remove) + '</div>'

                $(wrapper).html(content);
            }

            function removeCopyRight(reading, remove) {
                if (!remove) {
                    return reading;
                }

                for (var i = 0; i < 2; i++) {
                    reading = reading.substr(0, reading.lastIndexOf("<br />") - 1);
                }

                return reading;
            }

            function isError(text) {
                if (text.includes('Error : wrong')){
                    return true;
                }

                return false;
            }


            function fetchReading(wrapper, hideController, urlTitleReading, urlReading, remove) {
                
                $.get(urlTitleReading,

                    function (titleReading) {

                        if(isError(titleReading)){
                           return;
                        }

                        if (!$(hideController).is(':checked') && titleReading) {
                                
                           $.get(urlReading,

                              function (reading) {
                                 buildReading(wrapper, titleReading, reading, remove);
                              }

                           );

                        }
                    }
                );
            }

            function fetchLiturgy(urlLiturgy) {
                $.get(urlLiturgy,

                    function(liturgy) {

                        if (liturgy) {

                            $('.daily-readings-date').text(liturgy);

                        }
                    }
                );
            }

            function swipe() {
                $('.daily-readings-date').text('');
                $('.daily-readings-reading-heading').remove();
                $('.daily-readings-reading').remove();
                $('#no-readings-message').remove();
            }

            function retrieveReadings(targetDate, lang) {

                var urlLiturgy = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=liturgic_t';
                var urlTitleEpistle = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading_lt&content=EP';
                var urlEpistle = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading&content=EP';
                var urlTitleFirstReading = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading_lt&content=FR';
                var urlFirstReading = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading&content=FR';
                var urlTitlePsalm = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading_lt&content=PS';
                var urlPsalm = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading&content=PS';
                var urlTitleSecondReading = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading_lt&content=SR';
                var urlSecondReading = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading&content=SR';
                var urlTitleGospel = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading_lt&content=GSP';
                var urlGospel = 'https://feed.evangelizo.org/v2/reader.php?date=' + targetDate + '&lang=' + lang + '&type=reading&content=GSP';

                swipe();
                $('.daily-readings-date').text(targetDate);

                fetchLiturgy(urlLiturgy);

                fetchReading('#epistleReading', !DR_CONFIGS.hideFirstLecture, urlTitleEpistle, urlEpistle, true);
                fetchReading('#firstReading', !DR_CONFIGS.hideFirstLecture, urlTitleFirstReading, urlFirstReading, true);
                fetchReading('#psalmReading', !DR_CONFIGS.hidePsalm, urlTitlePsalm, urlPsalm, true);
                fetchReading('#secondReading', !DR_CONFIGS.hideSecondLecture, urlTitleSecondReading, urlSecondReading, true);
                fetchReading('#gospelReading', !DR_CONFIGS.hideGospel, urlTitleGospel, urlGospel, false);
            }

        });

    }
}




/** widget **/
function readToggle(context) {
    if (window.jQuery) {
        var dots = jQuery('.daily-readings-reading.' + context + ' .daily-readings-dots');
        var moreText = jQuery('.daily-readings-reading.' + context + ' .daily-readings-read-more');
        var btnText = jQuery('#' + context + '-read-more-daily-readings i');

        if (dots.css('display') === 'none') {
            dots.css('display', 'inline');
            btnText.removeClass('fa-chevron-up');
            btnText.addClass('fa-chevron-down');
            moreText.css('display', 'none');
        } else {
            dots.css('display', 'none');
            btnText.removeClass('fa-chevron-down');
            btnText.addClass('fa-chevron-up');
            moreText.css('display', 'inline');
        }
    }
}