/** widget **/
window.onload = function() {
    if (window.jQuery) {
        jQuery(document).ready(function($) {

            $(document).on("click", ".daily-readings-upload_image_button", function(e) {
                e.preventDefault();
                var $button = $(this);

                var file_frame = wp.media.frames.file_frame = wp.media({
                    title: 'Select or upload image',
                    library: { 
                        type: 'image'
                    },
                    button: {
                        text: 'Select'
                    },
                    multiple: false 
                });

                
                file_frame.on('select', function() {
                    
                    var attachment = file_frame.state().get('selection').first().toJSON();

                    $input = $button.parent().siblings('div.daily-readings-input-wrapper').find('input').first();
                    $input.val(attachment.url);
                    $input.change();

                    $img = $button.parent().siblings('div.daily-readings-preview-image-wrapper').find('img').first();
                    $img.attr('src', attachment.url);

                });

                file_frame.open();
            });

            $(document).on("click", ".daily-readings-remove_image_button", function(e) {
                e.preventDefault();
                var $button = $(this);

                $input = $button.parent().siblings('div.daily-readings-input-wrapper').find('input').first();
                $input.val('');
                $input.change();

                $img = $button.parent().siblings('div.daily-readings-preview-image-wrapper').find('img').first();
                $img.attr('src', '');

            });

        });

    }
}
